﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace GGJ
{
    internal class CEntity
    {
        public readonly Game1 game;

        protected Texture2D myTexture;

        public Rectangle myRectangle;

        public CEntity(Game1 game, Texture2D texture, Vector2 position)
        {
            this.game = game;
            game.entities.Add(this);
            myTexture = texture;
            myRectangle = new Rectangle((int)position.X, (int)position.Y, myTexture.Width, myTexture.Height);
        }

        internal void Dispose()
        {
            game.entities.Remove(this);
        }

        internal Rectangle Rectangle
        {
            get
            {
                return myRectangle;
            }
        }

        internal virtual void Draw(SpriteBatch begunSpriteBatch)
        {
            begunSpriteBatch.Draw(myTexture, myRectangle, Color.White);
        }

        internal virtual void Update()
        {
            //DO GAMEPLAY STUFF HERE
            
        }

    }
}
